<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output
        indent="yes"
        method="xml"
        omit-xml-declaration="no"
        version="1.0" />

    <xsl:template name="rtf">
        <xsl:apply-templates select="section" />
    </xsl:template>

    <xsl:template match="section">
        <xsl:for-each select="paragraph">
            <xsl:choose>
                <xsl:when test="count(following-sibling::paragraph)>0">
                    <fo:block>
                        <xsl:call-template name="paragraph" />
                    </fo:block>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="text()">
                        <xsl:call-template name="paragraph" />
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="paragraph">
        <xsl:choose>
            <xsl:when test="text/@alignment">
                <fo:block
                    line-height="9pt"
                    text-align="{text/@alignment}"
                    line-height-shift-adjustment="consider-shifts"
                    line-stacking-strategy="max-height"
                    space-before="0cm">
                    <xsl:apply-templates select="text" />
                </fo:block>
            </xsl:when>
            <xsl:when test="empty-text/@alignment">
                <fo:block
                    line-height="8pt"
                    text-align="{empty-text/@alignment}"
                    line-height-shift-adjustment="consider-shifts"
                    line-stacking-strategy="max-height"
                    space-before="0cm">
                    <xsl:apply-templates select="empty-text" />
                </fo:block>
            </xsl:when>
            <xsl:otherwise>
                <fo:block
                    line-height="9pt"
                    text-align="left"
                    line-height-shift-adjustment="consider-shifts"
                    line-stacking-strategy="max-height"
                    margin="2mm">
                    <xsl:apply-templates select="text" />
                </fo:block>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="text">
        <xsl:call-template name="TabReplace">
            <xsl:with-param
                name="stringIns"
                select="text()" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="empty-text">
        <xsl:if test="count(parent::node()/preceding-sibling::paragraph)>0">
            <fo:inline
                font-size="9pt"
                line-height="9pt"
                white-space-collapse="false">&#x00A0;</fo:inline>
        </xsl:if>
    </xsl:template>

    <xsl:template name="TabReplace">
        <xsl:param name="stringIns" />

        <!-- Tabstop in Leerzeichen -->
        <xsl:variable
            name="stringIns2"
            select="translate($stringIns,'&#x00AC;','&#x00A0;')" />
        <xsl:if test="not(contains($stringIns2,'&#x00B6;'))">
            <fo:inline font-size="9pt">
                <xsl:call-template name="SubstringReplace">
                    <xsl:with-param
                        name="stringIn"
                        select="$stringIns2" />
                </xsl:call-template>
            </fo:inline>
        </xsl:if>
        <xsl:if test="contains($stringIns2,'&#x00B6;')">
            <xsl:variable
                name="cell1"
                select="substring-before($stringIns2,'&#x00B6;')" />
            <xsl:variable
                name="cell2"
                select="substring-after($stringIns2,'&#x00B6;')" />
            <fo:table
                table-layout="fixed"
                width="100%"
                border="0"
                border-style="none">
                <fo:table-column
                    column-width="50%"
                    border="0"
                    border-style="none" />
                <fo:table-column
                    column-width="50%"
                    border="0"
                    border-style="none" />
                <fo:table-body
                    border="0"
                    border-style="none">
                    <fo:table-row
                        border="0"
                        border-style="none">
                        <fo:table-cell
                            border="0"
                            border-style="none"
                            margin="0"
                            margin-top="1pt"
                            margin-bottom="1pt">
                            <fo:block font-size="9pt">
                                <xsl:call-template name="SubstringReplace">
                                    <xsl:with-param
                                        name="stringIn"
                                        select="$cell1" />
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell
                            border="0"
                            border-style="none">
                            <fo:block
                                margin-top="1pt"
                                margin-bottom="1pt"
                                margin-left="0"
                                padding-left="0"
                                font-size="9pt">
                                <xsl:call-template name="SubstringReplace">
                                    <xsl:with-param
                                        name="stringIn"
                                        select="$cell2" />
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
