<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output
        indent="yes"
        method="xml"
        omit-xml-declaration="no"
        version="1.0" />

    <xsl:variable
        name="configDoc"
        select="document(projectFansMasterdata/@config)" />
    <xsl:variable
        name="BidInvDoc"
        select="document(projectFansMasterdata/@secFileName)" />

    <xsl:include href="Header.xsl" />
    <xsl:include href="CommonPDF.xsl" />

    <xsl:variable name="ReportName">
        Datenblatt L&#252;fter
    </xsl:variable>

    <xsl:template match="projectFansMasterdata">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master
                    margin-bottom="1.5cm"
                    margin-left="2cm"
                    margin-right="2cm"
                    margin-top="2cm"
                    master-name="simpleA4"
                    page-height="29.7cm"
                    page-width="21cm">
                    <fo:region-body
                        margin-bottom="1cm"
                        margin-top="5cm" />
                    <fo:region-before extent="5cm" />
                    <fo:region-after extent="1cm" />
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simpleA4">
                <xsl:call-template name="header">
                    <xsl:with-param
                        name="projectName"
                        select="project/@name" />
                </xsl:call-template>
                <xsl:call-template name="footnote" />
                <fo:flow
                    flow-name="xsl-region-body"
                    force-page-count="auto">
                    <xsl:apply-templates select="fans" />
                    <xsl:call-template name="terminator" />
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template
        match="fans"
        name="fans">
        <fo:block>
            <xsl:for-each select="fan">
                <xsl:choose>
                    <xsl:when test="count(preceding-sibling::fan)>0">
                        <fo:block break-before="page">
                            <xsl:call-template name="fan" />
                        </fo:block>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:block>
                            <xsl:call-template name="fan" />
                        </fo:block>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block>
    </xsl:template>

    <xsl:template name="fan">
        <fo:block>
            <xsl:apply-templates select="bidInv" />
        </fo:block>
        <fo:block>
            <xsl:call-template name="images" />
        </fo:block>
    </xsl:template>

    <xsl:template name="images">
        <fo:table
            table-layout="fixed"
            width="100%"
            border="0pt">
            <fo:table-column column-width="50%" />
            <fo:table-column column-width="50%" />
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell text-align="center">
                        <fo:block>
                            <xsl:if test="image1">
                                <fo:external-graphic
                                    src="{image1}"
                                    scaling="uniform"
                                    width="100%"
                                    height="6cm"
                                    content-height="scale-to-fit"
                                    content-width="scale-to-fit" />
                            </xsl:if>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell text-align="center">
                        <fo:block>
                            <xsl:if test="image2">
                                <fo:external-graphic
                                    src="{image2}"
                                    scaling="uniform"
                                    width="100%"
                                    height="6cm"
                                    content-height="scale-to-fit"
                                    content-width="scale-to-fit" />
                            </xsl:if>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="bidInv">
        <fo:table
            table-layout="fixed"
            width="100%">
            <fo:table-column column-width="18%" />
            <fo:table-column column-width="82%" />
            <fo:table-body>
                <fo:table-row keep-with-next="always">
                    <fo:table-cell>
                        <fo:block
                            margin="1mm"
                            font-size="9pt">
                            <xsl:value-of select="../@lvs-bidInv" />
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block
                            margin="1mm"
                            font-size="9pt">
                            <xsl:variable
                                name="ID"
                                select="../@id" />
                            <xsl:variable
                                name="bidInv"
                                select="$BidInvDoc/bidInvsProjectFans/bidInvGeneral[@id=$ID]" />
                            <xsl:apply-templates select="$bidInv/section" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block
                            margin="1mm"
                            font-size="9pt">
                            <xsl:value-of select="../@lvs" />
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell text-align="start">
                        <fo:block
                            margin="1mm"
                            font-size="9pt">
                            <xsl:call-template name="rtf" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

</xsl:stylesheet>