<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template name="header">
        <xsl:param name="projectName" />
        <fo:static-content flow-name="xsl-region-before">
            <fo:table
                table-layout="fixed"
                width="100%"
                border-width="1pt"
                border-style="solid"
                border-color="black"
                text-align="center">
                <fo:table-column column-width="30%" />
                <fo:table-column column-width="40%" />
                <fo:table-column column-width="30%" />
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell
                            number-rows-spanned="2"
                            border-bottom="1pt solid"
                            display-align="center">
                            <fo:block
                                width="100%"
                                font-size="0"
                                text-align="start"
                                margin="1pt">
                                <fo:external-graphic
                                    scaling="uniform"
                                    width="100%"
                                    height="2.5cm"
                                    content-height="scale-to-fit"
                                    content-width="scale-to-fit"
                                    src="{$configDoc/config/@logo}" />
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell text-align="center">
                            <fo:block
                                font-size="20pt"
                                font-weight="bold"
                                text-align="center">
                                L&#252;ftungsprojekt
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell
                            margin-right="3pt"
                            number-rows-spanned="2"
                            border-bottom="1pt solid">
                            <fo:block>
                                <xsl:if test="$configDoc/config/@emblem">
                                    <fo:external-graphic src="{$configDoc/config/@emblem}" />
                                </xsl:if>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell text-align="center">
                            <fo:block
                                font-size="10pt"
                                text-align="center">
                                <fo:block>
                                    <xsl:value-of select="$configDoc/config/@companyName" />
                                </fo:block>
                                <fo:block>
                                    <xsl:value-of select="$configDoc/config/@companyName2" />
                                </fo:block>
                                <fo:block>
                                    <xsl:value-of select="$configDoc/config/@street" />
                                </fo:block>
                                <fo:block>
                                    <xsl:value-of select="$configDoc/config/@plz" />
                                    <xsl:text> </xsl:text>
                                    <xsl:value-of select="$configDoc/config/@city" />
                                </fo:block>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
            <fo:block
                space-before="1mm"
                font-size="1pt">&#160;</fo:block>
            <fo:table
                table-layout="fixed"
                width="100%"
                border="0pt"
                text-align="center">
                <fo:table-column column-width="50%" />
                <fo:table-column column-width="50%" />
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell text-align="start">
                            <fo:block>
                                Projekt:
                                <xsl:value-of select="$projectName" />
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell text-align="end">
                            <fo:block
                                margin-top="1pt"
                                font-size="8pt">
                                erstellt am:
                                <xsl:value-of
                                    select="java:format(java:java.text.SimpleDateFormat.new('d. MMMM, yyyy'), java:java.util.Date.new())" />
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
            <fo:block>
                <fo:leader />
            </fo:block>
            <fo:table
                table-layout="fixed"
                width="100%"
                border="0">
                <fo:table-column column-width="100%" />
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell text-align="start">
                            <fo:block
                                font-size="14pt"
                                font-style="italic"
                                font-weight="bold">
                                <xsl:value-of select="$ReportName" />
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:static-content>
    </xsl:template>

    <xsl:template name="footnote">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block
                font-size="10pt"
                space-before="2mm"
                text-align="end">
                <fo:page-number />
                von
                <fo:page-number-citation ref-id="terminator" />
            </fo:block>
        </fo:static-content>
    </xsl:template>

    <xsl:template name="terminator">
        <fo:block
            id="terminator"
            font-size="1pt">&#160;</fo:block>
    </xsl:template>

    <xsl:template name="SubstringReplace">
        <xsl:param name="stringIn" />
        <xsl:choose>
            <xsl:when test="contains($stringIn,'$$DN$$')">
                <xsl:variable
                    name="first"
                    select="concat(substring-before($stringIn,'$$DN$$'),round(../../../@diameter), substring-after($stringIn,'$$DN$$'))" />
                <xsl:value-of select="$first" />
            </xsl:when>
            <xsl:when test="contains($stringIn,'$$DND$$')">
                <xsl:variable
                    name="second"
                    select="concat(substring-before($stringIn,'$$DND$$'),round(../../../@diameter), substring-after($stringIn,'$$DND$$' ))" />
                <xsl:variable
                    name="third"
                    select="concat(substring-before($second,'$$DNZ$$'),round(../../../@diameter2), substring-after($second,'$$DNZ$$' ))" />
                <xsl:value-of select="$third" />
            </xsl:when>
            <xsl:when test="contains($stringIn,'$$KW$$')">
                <xsl:variable
                    name="first"
                    select="concat(substring-before($stringIn,'$$KW$$'),round(../../../@power), substring-after($stringIn,'$$KW$$'))" />
                <xsl:value-of select="$first" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$stringIn" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
