<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:variable
        name="configDoc"
        select="document(massRoot/@config)" />
    <xsl:variable name="ReportName">
        Projektmassenaufstellung
    </xsl:variable>

    <xsl:include href="Header.xsl" />

    <xsl:template match="massRoot">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master
                    margin-bottom="1.5cm"
                    margin-left="2cm"
                    margin-right="2cm"
                    margin-top="2cm"
                    master-name="simpleA4"
                    page-height="29.7cm"
                    page-width="21cm">
                    <fo:region-body
                        margin-bottom="1cm"
                        margin-top="5cm" />
                    <fo:region-before extent="5cm" />
                    <fo:region-after extent="1cm" />
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simpleA4">
                <xsl:call-template name="header">
                    <xsl:with-param
                        name="projectName"
                        select="@name" />
                </xsl:call-template>
                <xsl:call-template name="footnote" />
                <fo:flow
                    flow-name="xsl-region-body"
                    force-page-count="auto">
                    <fo:block>
                        <xsl:apply-templates
                            select="category[@category = 'Lüftungsgeräte' and count(child::*)>0]" />
                        <xsl:apply-templates select="category[@category = 'Zubehör' and count(child::*)>0]" />
                        <xsl:apply-templates select="category[@category = 'Rohre' and count(child::*)>0]" />
                        <xsl:apply-templates
                            select="category[@category = 'Einbauteile' and count(child::*)>0]" />
                    </fo:block>
                    <xsl:call-template name="terminator" />
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template match="category">
        <fo:block
            font-size="12pt"
            font-weight="bold"
            keep-with-next="always">
            <xsl:value-of select="@category" />
        </fo:block>
        <xsl:apply-templates select="name" />
    </xsl:template>

    <xsl:template match="name">
        <fo:table
            table-layout="fixed"
            width="100%"
            border="0"
            keep-together="always">
            <fo:table-column column-width="75%" />
            <fo:table-column column-width="25%" />
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell border="0">
                        <fo:block
                            margin="1mm 0"
                            font-size="9pt"
                            font-weight="bold">
                            <xsl:value-of select="@name" />
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell
                        border="0"
                        text-align="end">
                        <fo:block
                            margin="1mm 0"
                            font-size="9pt"
                            font-weight="bold">
                            Stück
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <xsl:apply-templates select="diameter">
                    <xsl:sort
                        data-type="number"
                        select="@diameter" />
                    <xsl:sort
                        data-type="number"
                        select="@diameter2" />
                </xsl:apply-templates>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="diameter">
        <xsl:choose>
            <xsl:when test="@diameter != '0.0' and @diameter2 != '0.0'">
                <fo:table-row>
                    <fo:table-cell
                        border="0"
                        number-columns-spanned="2">
                        <fo:block
                            margin="1mm 0"
                            font-size="9pt">
                            <xsl:choose>
                                <xsl:when test="not(./part/@type='extension')">
                                    Durchgehende/Zustr&#246;mende Nennweite:
                                </xsl:when>
                                <xsl:otherwise>
                                    Durchmesser klein/groß:
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:value-of select="round(@diameter)" />
                            /
                            <xsl:value-of select="round(@diameter2)" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </xsl:when>
            <xsl:when test="number(@diameter) != 0">
                <xsl:choose>
                    <xsl:when test="../../@category='Lüftungsgeräte'" />
                    <xsl:otherwise>
                        <fo:table-row>
                            <fo:table-cell
                                border="0"
                                number-columns-spanned="2">
                                <fo:block
                                    margin="1mm 0"
                                    font-size="9pt">
                                    Nennweite:
                                    <xsl:value-of select="round(@diameter)" />
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
        <xsl:apply-templates select="part" />
        <xsl:if test="@diameter != '0.0'">
            <fo:table-row>
                <fo:table-cell>
                    <fo:block />
                </fo:table-cell>
                <fo:table-cell text-align="end">
                    <fo:block
                        margin="1mm"
                        font-size="9pt">
                        <xsl:choose>
                            <xsl:when test="../../@category='Lüftungsgeräte'">
                                Summe:
                            </xsl:when>
                            <xsl:when test="../../@category='Zubehör'">
                                Gesamtanzahl:
                            </xsl:when>
                            <xsl:when test="../../@category='Rohre'">
                                Summe Dimension:
                            </xsl:when>
                            <xsl:when test="../../@category='Einbauteile'">
                                Summe Dimension:
                            </xsl:when>
                        </xsl:choose>
                        <xsl:value-of select="ceiling(@count)" />
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:if>
        <xsl:if test="@diameter = '0.0'">
            <fo:table-row>
                <fo:table-cell
                    border="1pt solid"
                    text-align="end">
                    <fo:block
                        margin="1mm"
                        font-size="9pt">
                        Gesamtanzahl
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell border="1pt solid">
                    <fo:block
                        font-size="9pt"
                        margin="1mm"
                        text-align="end">
                        <xsl:value-of select="ceiling(@count)" />
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:if>
    </xsl:template>

    <xsl:template match="part">
        <fo:table-row>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-size="9pt">
                    <xsl:value-of select="@tube" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell
                border="1pt solid"
                text-align="end">
                <fo:block
                    margin="1mm"
                    font-size="9pt">
                    <xsl:choose>
                        <xsl:when test="../../../@category='Rohre'">
                            <xsl:value-of
                                select="translate(format-number((round(number(@count)*100)) div 100,'0.00'),'.',',')" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="ceiling(@count)" />
                        </xsl:otherwise>
                    </xsl:choose>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

</xsl:stylesheet>
