<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:variable
        name="configDoc"
        select="document(tubeConstructionOverview/@config)" />
    <xsl:variable name="ReportName"></xsl:variable>
    <xsl:include href="Header.xsl" />

    <xsl:template match="tubeConstructionOverview">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master
                    margin-bottom="1.5cm"
                    margin-left="2cm"
                    margin-right="2cm"
                    margin-top="2cm"
                    master-name="simpleA4"
                    page-height="29.7cm"
                    page-width="21cm">
                    <fo:region-body
                        margin-bottom="1cm"
                        margin-top="4cm" />
                    <fo:region-before extent="4cm" />
                    <fo:region-after extent="1cm" />
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simpleA4">
                <xsl:call-template name="header">
                    <xsl:with-param
                        name="projectName"
                        select="@name" />
                </xsl:call-template>
                <xsl:call-template name="footnote" />
                <fo:flow
                    flow-name="xsl-region-body"
                    force-page-count="auto">
                    <xsl:apply-templates select="tubeConstruction" />
                    <xsl:call-template name="terminator" />
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="tubeConstruction">
        <xsl:choose>
            <xsl:when test="position()='1'">
                <fo:block font-size="1pt">&#160;</fo:block>
            </xsl:when>
            <xsl:otherwise>
                <fo:block
                    break-before="page"
                    font-size="1pt">&#160;</fo:block>
            </xsl:otherwise>
        </xsl:choose>
        <fo:block
            font-weight="bold"
            font-size="14pt">
            Strang&#252;bersicht
            <xsl:value-of select="@name" />
            <xsl:apply-templates select="floor" />
        </fo:block>
    </xsl:template>

    <xsl:template match="floor">
        <fo:block
            space-before="5mm"
            font-size="1pt">&#160;</fo:block>
        <fo:block
            text-align="center"
            font-weight="bold"
            font-size="12pt">
            <xsl:value-of select="@comment" />
            &#160;
            <xsl:value-of select="@nr" />
        </fo:block>
        <fo:block font-size="9pt">
            <xsl:apply-templates select="fans" />
            <xsl:apply-templates select="installationParts" />
            <xsl:apply-templates select="tPieces" />
            <xsl:apply-templates select="tubes" />
        </fo:block>
    </xsl:template>

    <xsl:template match="tubes">
        <xsl:if test="tube">
            <fo:block
                space-before="3mm"
                font-size="1pt">&#160;</fo:block>
            <fo:block font-weight="bold">
                Rohrleitungen
            </fo:block>
            <fo:block>
                <fo:table
                    table-layout="fixed"
                    width="100%"
                    border="1pt solid black">
                    <fo:table-column column-width="10%" />
                    <fo:table-column column-width="25%" />
                    <fo:table-column column-width="20%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-header>
                        <fo:table-row>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    TS
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    NW [mm]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    Rohrl&#228;nge [m]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    V [m&#179;/h]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    P verl [Pa]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    C [m/s]
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:apply-templates select="tube">
                            <xsl:sort
                                data-type="number"
                                select="substring-after(@nr,'R')" />
                        </xsl:apply-templates>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </xsl:if>
    </xsl:template>

    <xsl:template match="fans">
        <xsl:if test="fan">
            <fo:block
                space-before="3mm"
                font-size="1pt">&#160;</fo:block>
            <fo:block font-weight="bold">
                L&#252;fter
            </fo:block>
            <fo:block>
                <fo:table
                    table-layout="fixed"
                    width="100%"
                    border="1pt solid black">
                    <fo:table-column column-width="10%" />
                    <fo:table-column column-width="25%" />
                    <fo:table-column column-width="20%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-header>
                        <fo:table-row>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    TS
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    Bezeichnung
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    NW [mm]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    planm. Vol. [m&#179;/h]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    V-tats. [m&#179;/h]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    P verl [Pa]
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:apply-templates select="fan">
                            <xsl:sort
                                data-type="number"
                                select="substring-after(@nr,'L')" />
                        </xsl:apply-templates>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </xsl:if>
    </xsl:template>

    <xsl:template match="installationParts">
        <xsl:if test="count(child::node())>0">
            <fo:block
                space-before="3mm"
                font-size="1pt">&#160;</fo:block>
            <fo:block font-weight="bold">
                Einbauteile
            </fo:block>
            <fo:block>
                <fo:table
                    table-layout="fixed"
                    width="100%"
                    border="1pt solid black">
                    <fo:table-column column-width="10%" />
                    <fo:table-column column-width="25%" />
                    <fo:table-column column-width="20%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-header>
                        <fo:table-row>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    TS
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    Bezeichnung
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    NW [mm]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    V [m&#179;/h]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    P verl [Pa]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    C [m/s]
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:apply-templates select="exhaustDuct" />
                        <xsl:apply-templates select="*[not(self::exhaustDuct)]">
                            <xsl:sort select="@nr" />
                            <xsl:sort
                                data-type="number"
                                select="@number" />
                        </xsl:apply-templates>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </xsl:if>
    </xsl:template>

    <xsl:template match="tPieces">
        <xsl:if test="tPiece">
            <fo:block
                space-before="3mm"
                font-size="1pt">&#160;</fo:block>
            <fo:block font-weight="bold">
                Abzweigungen
            </fo:block>
            <fo:block>
                <fo:table
                    table-layout="fixed"
                    width="100%"
                    border="1pt solid black">
                    <fo:table-column column-width="10%" />
                    <fo:table-column column-width="25%" />
                    <fo:table-column column-width="20%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-column column-width="15%" />
                    <fo:table-header>
                        <fo:table-row>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    TS
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    NW durchstr&#246;mend [mm]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    NW zustr&#246;mend [mm]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    V-gesamt [m&#179;/h]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    P verl-ds [Pa]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell border="1pt solid">
                                <fo:block
                                    margin="1mm"
                                    font-weight="bold">
                                    P verl-zs [Pa]
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:apply-templates select="tPiece">
                            <xsl:sort
                                data-type="number"
                                select="substring-after(@nr,'A')" />
                        </xsl:apply-templates>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </xsl:if>
    </xsl:template>

    <xsl:template match="tube">
        <fo:table-row>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@nr" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@innerDiameter" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of
                        select="translate(format-number((round(number(@length)*100)) div 100,'0.00'),'.',',')" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@airFlow" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@pressureLoss" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@flowSpeed" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="fan">
        <fo:table-row>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@nr" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@name" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@innerDiameter" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@pAirFlow" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@airFlow" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@pressureLoss" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="tPiece">
        <fo:table-row>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@nr" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@innerDiameter" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@branchInnerDiameter" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@airFlow" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@pressureLoss" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@branchPressureLoss" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="*">
        <fo:table-row>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@nr" />
                    <xsl:value-of select="@number" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@name" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:value-of select="@innerDiameter" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@airFlow" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@pressureLoss" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell border="1pt solid">
                <fo:block
                    margin="1mm"
                    font-weight="normal">
                    <xsl:call-template name="commaToDot">
                        <xsl:with-param
                            name="string"
                            select="@flowSpeed" />
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="commaToDot">
        <xsl:param name="string"></xsl:param>
        <xsl:value-of select="translate((round(number($string)*100)) div 100,'.',',')" />
    </xsl:template>

</xsl:stylesheet>
	